import {useState, ChangeEvent, KeyboardEvent} from 'react'
import 'fork-awesome/css/fork-awesome.min.css'
import 'bulma/css/bulma.min.css'
import {
    Container,
    Form,
    Icon,
    Section
} from 'react-bulma-components'

type FirstLtterInWordProps = {
    onNewWord: (word: string) => void
}

function FirstLetterInWord(props: FirstLtterInWordProps) {

    const [input, setInput] = useState('')
    const [showError, setShowError] = useState(false)

    const handleNewWord = function() {
        const trimmedInput = input.trim()
        if (trimmedInput.length > 0) {
            if (trimmedInput.includes(' ')) {
                setShowError(true)
            } else {
                props.onNewWord(trimmedInput)
                setInput('')
                setShowError(false)
            }
        }

    }

    const handleKeyDown = function(event: KeyboardEvent<HTMLInputElement>) {
        if (event.code == 'Enter') {
            handleNewWord()
        }
    }
    
    const handleChange = function(event: ChangeEvent<HTMLInputElement>) {
        setInput(event.target.value)
    }

    let helpStyle = {display: 'none'}
    if (showError) {
        helpStyle = {display: 'block'}
    }

    return (
        <Section size="small">
            <Container>
                <h1 className="title">Vad är första bokstaven i ordet?</h1>
                <Form.Control>
                    <Form.Input
                        size="large"
                        placeholder="Skriv in ett ord och tryck enter..."
                        onKeyDown={handleKeyDown}
                        onChange={handleChange}
                        value={input}/>
                    <Icon align="right">
                        <i className="fa fa-search"></i>
                    </Icon>
                </Form.Control>
                <p className="help is-danger" style={helpStyle}>Du får bara skriva ett ord.</p>
            </Container>
        </Section>
    )
}

export default FirstLetterInWord